﻿using System;
using System.Collections.Generic;
using System.Data;
using DataAccess.DataRows;

namespace DataAccess.DataTables
{
    public class ConfigurationDataTable : DataTable
    {
        public ConfigurationDataTable()
        {
            this.Columns.Add(new DataColumn("ID", typeof(int)));
            this.Columns.Add(new DataColumn("KEY", typeof(string)));
            this.Columns.Add(new DataColumn("VALUE", typeof(string)));
        }

        public ConfigurationDataRow this[int index]
        {
            get
            {
                return (ConfigurationDataRow)Rows[index];
            }
        }

        public void Add(ConfigurationDataRow row)
        {
            this.Rows.Add(row);
        }

        public void Remove(ConfigurationDataRow row)
        {
            this.Rows.Remove(row);
        }

        public ConfigurationDataRow GetNewRow()
        {
            ConfigurationDataRow row = (ConfigurationDataRow)NewRow();
            return row;
        }

        protected override Type GetRowType()
        {
            return typeof(ConfigurationDataRow);
        }

        protected override DataRow NewRowFromBuilder(DataRowBuilder builder)
        {
            return new ConfigurationDataRow(builder);
        }

        public IEnumerator<ConfigurationDataRow> GetEnumerator()
        {
            List<ConfigurationDataRow> rows = new List<ConfigurationDataRow>();

            for (int i = 0; i < this.Rows.Count; i++)
            {
                rows.Add((ConfigurationDataRow)this.Rows[i]);
            }

            return rows.GetEnumerator();
        }
    }
}
